/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.PenetrationData;
import dev.toma.gunsrpg.util.properties.Properties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class AbstractPenetratingProjectile
extends AbstractProjectile {
    public AbstractPenetratingProjectile(EntityType<? extends AbstractPenetratingProjectile> type, World level) {
        super(type, level);
    }

    public AbstractPenetratingProjectile(EntityType<? extends AbstractPenetratingProjectile> type, World world, LivingEntity owner) {
        super(type, world, owner);
    }

    protected abstract void handleEntityCollision(EntityRayTraceResult var1);

    @Override
    protected final void func_213868_a(EntityRayTraceResult result) {
        this.handleEntityCollision(result);
        PenetrationData penetrationData = this.getProperty(Properties.PENETRATION);
        if (penetrationData != null) {
            boolean noEnergy = penetrationData.collide(result.func_216348_a());
            this.mulDamage(penetrationData.getMultiplier());
            if (noEnergy) {
                this.func_70106_y();
            } else {
                Vector3d pos = this.func_213303_ch();
                Vector3d mov = pos.func_178787_e(this.func_213322_ci());
                this.checkForCollisions(pos, mov);
            }
        }
    }

    protected boolean func_230298_a_(Entity entity) {
        PenetrationData penetrationData = this.getProperty(Properties.PENETRATION);
        return super.func_230298_a_(entity) && (penetrationData == null || penetrationData.getLastHit() != entity);
    }
}

